/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether;

import architectury_inject_MineTogether_common_ea10b52233864346909d0a2d25f045a6_d8b7798c2ebac22bb2cb8d86d893e7dc26a92267a82e149b750eaf5cd1b36606minetogether610devjar.PlatformMethods;
import dev.architectury.platform.Platform;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.MineTogetherPlatform;
import net.creeperhost.minetogether.MineTogetherServer;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.web.ApiClient;
import net.creeperhost.minetogether.lib.web.DynamicWebAuth;
import net.creeperhost.minetogether.lib.web.WebEngine;
import net.creeperhost.minetogether.lib.web.apache.ApacheWebEngine;
import net.creeperhost.minetogether.orderform.WebUtils;
import net.creeperhost.minetogether.util.Log4jUtils;
import net.creeperhost.minetogether.util.ModPackInfo;
import net.creeperhost.minetogether.util.SignatureVerifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MineTogether {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "minetogether";
    public static final String FINGERPRINT = SignatureVerifier.generateSignature();
    public static final DynamicWebAuth AUTH = new DynamicWebAuth();
    public static final WebEngine WEB_ENGINE = new ApacheWebEngine();
    public static final ApiClient API = ApiClient.builder().webEngine(WEB_ENGINE).addUserAgentSegment("MineTogether-lib/2.5").addUserAgentSegment("MineTogether-mod/" + MineTogetherPlatform.getVersion()).addUserAgentSegment("Minecraft/" + Platform.getMinecraftVersion()).addUserAgentSegment("Modloader/" + PlatformMethods.getCurrentTarget()).webAuth(AUTH).build();

    public static void init() {
        Log4jUtils.attachMTLogs(Platform.getGameFolder().resolve("logs"));
        LOGGER.info("Initializing MineTogether!");
        AUTH.setHeader("Fingerprint", FINGERPRINT);
        Config.loadConfig(Platform.getConfigFolder().resolve("minetogether.json"));
        if (Config.instance().debugMode) {
            LOGGER.warn("Debug mode enabled. Prepare for _VERY_ verbose logging!");
        }
        ModPackInfo.init();
        ModPackInfo.waitForInfo(info -> AUTH.setHeader("Identifier", info.realName));
        switch (Platform.getEnv()) {
            case CLIENT: {
                MineTogetherClient.init();
                break;
            }
            case DEDICATED_SERVER: {
                MineTogetherServer.init();
            }
        }
    }

    static {
        WebUtils.userAgent = WebUtils.userAgent + " MineTogether-lib/2.5";
        WebUtils.userAgent = WebUtils.userAgent + " MineTogether-mod/" + MineTogetherPlatform.getVersion();
        WebUtils.userAgent = WebUtils.userAgent + " Minecraft/" + Platform.getMinecraftVersion();
        WebUtils.userAgent = WebUtils.userAgent + " Modloader/" + PlatformMethods.getCurrentTarget();
    }
}

